--[[
    SetupModeEvent

    Multiplayer Sync Event for the RealGPS's Setup Mode toggle.

	@author: 		BayernGamers
	@date: 			11.03.2025
	@version:		2.0

	History:		v1.0 @15.07.2023 - initial implementation in FS 22
                    ------------------------------------------------------------------------------------------------------
                    v2.0 @11.03.2025 - convert and re-write for FS25
                    ------------------------------------------------------------------------------------------------------
	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
SetupModeEvent = {}

local SetupModeEvent_mt = Class(SetupModeEvent, Event)

InitEventClass(SetupModeEvent, "SetupModeEvent")

function SetupModeEvent:emptyNew()
    local self = Event.new(SetupModeEvent_mt)
    return self
end

function SetupModeEvent.new(vehicle, active)
    local self = SetupModeEvent:emptyNew()
    self.vehicle = vehicle
    self.active = active

    return self
end

function SetupModeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.active)
end

function SetupModeEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.active = streamReadBool(streamId)
    self:run(connection)
end

function SetupModeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
    if self.vehicle ~= nil then
        self.vehicle.spec_realGPS.isInSetupMode = self.active
        RealGPS.updateActionEvents(self.vehicle)
    end
end

function SetupModeEvent.sendEvent(vehicle, active, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(SetupModeEvent.new(vehicle, active), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(SetupModeEvent.new(vehicle, active))
        end
    end
end