---@class VehicleStorageEvent
VehicleStorageEvent = {}
local VehicleStorageEvent_mt = Class(VehicleStorageEvent, Event)

InitEventClass(VehicleStorageEvent, "VehicleStorageEvent")

function VehicleStorageEvent.emptyNew()
  vsDebug("VSE-emptyNew")
	return Event.new(VehicleStorageEvent_mt)
end

function VehicleStorageEvent.new(vehicle)
  vsDebug("VSE-new")
	local self = VehicleStorageEvent.emptyNew()
  self.vehicle = vehicle
	return self
end

function VehicleStorageEvent:readStream(streamId, connection)
  vsDebug("VSE-readStream")
  -- Get data from clients
  self.vehicle = NetworkUtil.readNodeObject(streamId)
	self:run(connection)
end

function VehicleStorageEvent:writeStream(streamId, connection)
  vsDebug("VSE-writeStream")
  -- Send data out to clients
  NetworkUtil.writeNodeObject(streamId, self.vehicle)  
end

function VehicleStorageEvent:run(connection)
  vsDebug("VSE-run")
  VehicleShopStorage:storeVehicle(self.vehicle)
end

function VehicleStorageEvent.sendEvent(vehicle)
  vsDebug("VSE-sendEvent")
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() then
      vsDebug("Local Server Host")
      VehicleShopStorage:storeVehicle(vehicle)
    else
      vsDebug("Dedicated Server Host")
  		g_server:broadcastEvent(VehicleStorageEvent.new(vehicle))
    end
    return
	end
  vsDebug("Client")
	g_client:getServerConnection():sendEvent(VehicleStorageEvent.new(vehicle))
end