---@class VehicleSpawnEvent
VehicleSpawnEvent = {}
local VehicleSpawnEvent_mt = Class(VehicleSpawnEvent, Event)

InitEventClass(VehicleSpawnEvent, "VehicleSpawnEvent")

function VehicleSpawnEvent.emptyNew()
  vsDebug("VSE-emptyNew")
	return Event.new(VehicleSpawnEvent_mt)
end

function VehicleSpawnEvent.new(vehicleXmlFile,farmId,spawnLocationData,userId)
  vsDebug("VSE-new")
	local self = VehicleSpawnEvent.emptyNew()
  self.vehicleXmlFile = vehicleXmlFile
  self.farmId = farmId
  self.rotX = spawnLocationData.rotX
  self.dirPerpX = spawnLocationData.dirPerpX
  self.dirPerpY = spawnLocationData.dirPerpY
  self.yOffset = spawnLocationData.yOffset
  self.maxHeight = spawnLocationData.maxHeight
  self.length = spawnLocationData.length
  self.startZ = spawnLocationData.startZ
  self.dirX = spawnLocationData.dirX
  self.startX = spawnLocationData.startX
  self.nodeEnd = spawnLocationData.nodeEnd
  self.dirY = spawnLocationData.dirY
  self.rotZ = spawnLocationData.rotZ
  self.width = spawnLocationData.width
  self.startY = spawnLocationData.startY
  self.maxWidth = spawnLocationData.maxWidth
  self.dirPerpZ = spawnLocationData.dirPerpZ
  self.dirZ = spawnLocationData.dirZ
  self.nodeStart = spawnLocationData.nodeStart
  self.rotY = spawnLocationData.rotY
  self.maxLength = spawnLocationData.maxLength
  self.palletRotationOffset = spawnLocationData.palletRotationOffset
  self.userId = userId

	return self
end

function VehicleSpawnEvent:readStream(streamId, connection)
  vsDebug("VSE-readStream")
  -- Get data from clients
  self.vehicleXmlFile = NetworkUtil.convertFromNetworkFilename(streamReadString(streamId))
  self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
  self.rotX = streamReadFloat32(streamId)
  self.dirPerpX = streamReadFloat32(streamId)
  self.dirPerpY = streamReadFloat32(streamId)
  self.yOffset = streamReadFloat32(streamId)
  self.maxHeight = streamReadFloat32(streamId)
  self.length = streamReadFloat32(streamId)
  self.startZ = streamReadFloat32(streamId)
  self.dirX = streamReadFloat32(streamId)
  self.startX = streamReadFloat32(streamId)
  self.nodeEnd = streamReadFloat32(streamId)
  self.dirY = streamReadFloat32(streamId)
  self.rotZ = streamReadFloat32(streamId)
  self.width = streamReadFloat32(streamId)
  self.startY = streamReadFloat32(streamId)
  self.maxWidth = streamReadFloat32(streamId)
  self.dirPerpZ = streamReadFloat32(streamId)
  self.dirZ = streamReadFloat32(streamId)
  self.nodeStart = streamReadFloat32(streamId)
  self.rotY = streamReadFloat32(streamId)
  self.maxLength = streamReadFloat32(streamId)
  self.palletRotationOffset = streamReadFloat32(streamId)
  self.userId = User.streamReadUserId(streamId)

	self:run(connection)
end

function VehicleSpawnEvent:writeStream(streamId, connection)
  vsDebug("VSE-writeStream")
  -- Send data out to clients
  streamWriteString(streamId, NetworkUtil.convertToNetworkFilename(self.vehicleXmlFile))
  streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
  streamWriteFloat32(streamId, self.rotX)
  streamWriteFloat32(streamId, self.dirPerpX)
  streamWriteFloat32(streamId, self.dirPerpY)
  streamWriteFloat32(streamId, self.yOffset)
  streamWriteFloat32(streamId, self.maxHeight)
  streamWriteFloat32(streamId, self.length)
  streamWriteFloat32(streamId, self.startZ)
  streamWriteFloat32(streamId, self.dirX)
  streamWriteFloat32(streamId, self.startX)
  streamWriteFloat32(streamId, self.nodeEnd)
  streamWriteFloat32(streamId, self.dirY)
  streamWriteFloat32(streamId, self.rotZ)
  streamWriteFloat32(streamId, self.width)
  streamWriteFloat32(streamId, self.startY)
  streamWriteFloat32(streamId, self.maxWidth)
  streamWriteFloat32(streamId, self.dirPerpZ)
  streamWriteFloat32(streamId, self.dirZ)
  streamWriteFloat32(streamId, self.nodeStart)
  streamWriteFloat32(streamId, self.rotY)
  streamWriteFloat32(streamId, self.maxLength)
  streamWriteFloat32(streamId, self.palletRotationOffset)
  User.streamWriteUserId(streamId, self.userId)
end

function VehicleSpawnEvent:run(connection)
  vsDebug("VSE-run")

  local spawnLocationData = {
    rotX = self.rotX,
    dirPerpX = self.dirPerpX,
    dirPerpY = self.dirPerpY,
    yOffset = self.yOffset,
    maxHeight = self.maxHeight,
    length = self.length,
    startZ = self.startZ,
    dirX = self.dirX,
    startX = self.startX,
    nodeEnd = self.nodeEnd,
    dirY = self.dirY,
    rotZ = self.rotZ,
    width = self.width,
    startY = self.startY,
    maxWidth = self.maxWidth,
    dirPerpZ = self.dirPerpZ,
    dirZ = self.dirZ,
    nodeStart = self.nodeStart,
    rotY = self.rotY,
    maxLength = self.maxLength,
    palletRotationOffset = self.palletRotationOffset,
  }

  g_vehicleShopStorage:loadVehicle(self.vehicleXmlFile,self.farmId,spawnLocationData,self.userId)
end

function VehicleSpawnEvent.sendEvent(vehicleXmlFile,farmId,spawnLocationData,userId)
  vsDebug("VSE-sendEvent")
  vsDebug(spawnLocationData)
  -- Make sure spawnLocationData has data
  if spawnLocationData ~= nil and spawnLocationData[1] ~= nil and spawnLocationData[1].rotX ~= nil then
    if g_server ~= nil then
      if g_client:getServerConnection():getIsLocal() then
        vsDebug("Local Server Host")
        g_vehicleShopStorage:loadVehicle(vehicleXmlFile,farmId,spawnLocationData[1],userId)
      else
        vsDebug("Dedicated Server Host")
        g_server:broadcastEvent(VehicleSpawnEvent.new(vehicleXmlFile,farmId,spawnLocationData[1],userId))
      end
      return
    end
    vsDebug("Client")
    g_client:getServerConnection():sendEvent(VehicleSpawnEvent.new(vehicleXmlFile,farmId,spawnLocationData[1],userId))
  else
    print("Warning: no spawn information was provided.  Unable to spawn vehicle at correct location.")
    ShowDialogEvent.sendEvent(userId,g_i18n:getText("info_spawnError"),DialogElement.TYPE_WARNING)
  end
end