---@class VehicleListEvent
VehicleListEvent = {}
local VehicleListEvent_mt = Class(VehicleListEvent, Event)

InitEventClass(VehicleListEvent, "VehicleListEvent")

function VehicleListEvent.emptyNew()
  vsDebug("VLE-emptyNew")
	return Event.new(VehicleListEvent_mt)
end

function VehicleListEvent.new(farmId,uniqueId,filename,age,price,operatingTime,damage,paint,vehicleXmlFile)
  vsDebug("VLE-new")
	local self = VehicleListEvent.emptyNew()
  self.filename = filename
  self.vehicleXmlFile = vehicleXmlFile
  self.farmId = farmId
  self.uniqueId = uniqueId
  self.age = age
  self.price = price
  self.operatingTime = operatingTime
  self.damage = damage
  self.paint = paint
    
  return self
end

function VehicleListEvent:readStream(streamId, connection)
  vsDebug("VLE-readStream")
  -- Get data from clients
  self.filename = NetworkUtil.convertFromNetworkFilename(streamReadString(streamId))
  self.vehicleXmlFile = NetworkUtil.convertFromNetworkFilename(streamReadString(streamId))
  self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
  self.uniqueId = streamReadString(streamId)
  self.age = streamReadFloat32(streamId)
  self.price = streamReadFloat32(streamId)
  self.operatingTime = streamReadFloat32(streamId)
  self.damage = streamReadFloat32(streamId)
  self.paint = streamReadFloat32(streamId)

	self:run(connection)
end

function VehicleListEvent:writeStream(streamId, connection)
  vsDebug("VLE-writeStream")
  -- Send data out to clients
  streamWriteString(streamId, NetworkUtil.convertToNetworkFilename(self.filename))
  streamWriteString(streamId, NetworkUtil.convertToNetworkFilename(self.vehicleXmlFile))
  streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
  streamWriteString(streamId, self.uniqueId)
  streamWriteFloat32(streamId, self.age)
  streamWriteFloat32(streamId, self.price)
  streamWriteFloat32(streamId, self.operatingTime)
  streamWriteFloat32(streamId, self.damage)
  streamWriteFloat32(streamId, self.paint)
end

function VehicleListEvent:run(connection)
  vsDebug("VLE-run")

  local storeItem = g_storeManager:getItemByXMLFilename(self.filename)

  local curVehicleData = {
    uniqueId = self.uniqueId,
    filename = self.filename,
    age = self.age,
    price = self.price,
    operatingTime = self.operatingTime,
    damage = self.damage,
    paint = self.paint,
    storeItem = storeItem,
    vehicleXmlFile = self.vehicleXmlFile
  }

  g_workshopStorageScreen:loadVehicleRequest(curVehicleData,self.farmId)

end

function VehicleListEvent.sendEvent(farmId,uniqueId,filename,age,price,operatingTime,damage,paint,vehicleXmlFile)
  vsDebug("VLE-sendEvent")
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() and g_dedicatedServer == nil then
      vsDebug("VLE Local Server Host")
      local storeItem = g_storeManager:getItemByXMLFilename(filename)

      local curVehicleData = {
        uniqueId = uniqueId,
        filename = filename,
        age = age,
        price = price,
        operatingTime = operatingTime,
        damage = damage,
        paint = paint,
        storeItem = storeItem,
        vehicleXmlFile = vehicleXmlFile
      }

      g_workshopStorageScreen:loadVehicleRequest(curVehicleData,farmId)
    else
      vsDebug("VLE Dedicated Server Host")
  		g_server:broadcastEvent(VehicleListEvent.new(farmId,uniqueId,filename,age,price,operatingTime,damage,paint,vehicleXmlFile))
    end
    return
	end
  vsDebug("VLE Client")
	g_client:getServerConnection():sendEvent(VehicleListEvent.new(farmId,uniqueId,filename,age,price,operatingTime,damage,paint,vehicleXmlFile))
end