---@class ShowDialogEvent
ShowDialogEvent = {}
local ShowDialogEvent_mt = Class(ShowDialogEvent, Event)

InitEventClass(ShowDialogEvent, "ShowDialogEvent")

function ShowDialogEvent.emptyNew()
  vsDebug("VRE-emptyNew")
	return Event.new(ShowDialogEvent_mt)
end

function ShowDialogEvent.new(userId,infoText,dialogType)
  vsDebug("VRE-new")
	local self = ShowDialogEvent.emptyNew()
  self.userId = userId
  self.infoText = infoText
  self.dialogType = Utils.getNoNil(dialogType, DialogElement.TYPE_INFO)

	return self
end

function ShowDialogEvent:readStream(streamId, connection)
  vsDebug("VRE-readStream")
  -- Get data from clients
  self.userId = User.streamReadUserId(streamId)
  self.infoText = streamReadString(streamId)
  self.dialogType = streamReadInt8(streamId)

	self:run(connection)
end

function ShowDialogEvent:writeStream(streamId, connection)
  vsDebug("VRE-writeStream")
  -- Send data out to clients
  User.streamWriteUserId(streamId, self.userId)
  streamWriteString(streamId, self.infoText)
  streamWriteInt8(streamId, self.dialogType)

end

function ShowDialogEvent:run(connection)
  vsDebug("VRE-run")
  if g_localPlayer.userId == self.userId then
    InfoDialog.show(self.infoText,nil,nil,self.dialogType)
  end
end

function ShowDialogEvent.sendEvent(userId,infoText,dialogType)
  vsDebug("VRE-sendEvent")
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() and g_dedicatedServer == nil then
      vsDebug("VRE Local Server Host")
      InfoDialog.show(infoText,nil,nil,dialogType)
    else
      vsDebug("VRE Dedicated Server Host")
  		g_server:broadcastEvent(ShowDialogEvent.new(userId,infoText,dialogType))
    end
    return
	end
  vsDebug("VRE Client")
	g_client:getServerConnection():sendEvent(ShowDialogEvent.new(userId,infoText,dialogType))
end


