-- Main mod load file for Vehicle Shop Storage Mod
local modDirectory = g_currentModDirectory or ""
local modName      = g_currentModName or "unknown"
local modProfilePath = getUserProfileAppPath()
local modEnvironment
local modEnvironmentWSS
local modSettingsFolderPath = modProfilePath  .. "modSettings/" .. modName
local vehiclesFolderPath = modSettingsFolderPath  .. "/vehicles"

-- files to load
local sourceFiles = {
  -- Debug
  "scripts/vsDebug.lua",
  -- Main Functions
  "scripts/vehicleShopStorage.lua",
  "scripts/workshopStorageScreen.lua",
  -- Events
  "scripts/vehicleStorageEvent.lua",
  "scripts/vehicleReloadEvent.lua",
  "scripts/vehicleListEvent.lua",
  'scripts/vehicleSpawnEvent.lua',
  'scripts/showDialogEvent.lua',
  'scripts/showMessageDialogEvent.lua',
  'scripts/hideMessageDialogEvent.lua',
}

---Load all of the source files
for _, file in ipairs(sourceFiles) do
  source(modDirectory .. file)
end

-- load on mission load
local function load(mission)
	assert(g_vehicleShopStorage == nil)
	modEnvironment = VehicleShopStorage:new(mission, g_i18n, modDirectory, modName)
	getfenv(0)["g_vehicleShopStorage"] = modEnvironment

	assert(g_workshopStorageScreen == nil)
	modEnvironmentWSS = WorkshopStorageScreen:new(mission, g_i18n, modDirectory, modName, nil)
	getfenv(0)["g_workshopStorageScreen"] = modEnvironmentWSS

  if mission:getIsClient() then
    addModEventListener(modEnvironment)
		addModEventListener(modEnvironmentWSS)
  end
end

-- unload on mission unload
local function unload()
  removeModEventListener(modEnvironment)
  removeModEventListener(modEnvironmentWSS)

  if modEnvironment ~= nil then
    modEnvironment = nil
    if g_vehicleShopStorage ~= nil then
      getfenv(0)["g_vehicleShopStorage"] = nil
    end
  end

  if modEnvironmentWSS ~= nil then
    modEnvironmentWSS = nil
    if g_workshopStorageScreen ~= nil then
      getfenv(0)["g_workshopStorageScreen"] = nil
    end
  end
end

-- start the mod functions
local function init()

  -- Create folders for this mod in mod settings
  if ( not fileExists(modSettingsFolderPath) ) then createFolder(modSettingsFolderPath) end
  -- Create folder for vehicle storage if not one already
  if ( not fileExists(vehiclesFolderPath) ) then createFolder(vehiclesFolderPath) end

  -- Load in the functions that make things work
	FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)

	Mission00.load = Utils.prependedFunction(Mission00.load, load)

  -- Adds button to the workshop screen
  WorkshopScreen.setVehicle = Utils.appendedFunction(WorkshopScreen.setVehicle, VehicleShopStorage.setVehicle)

  -- Adds mods reset places to the mix
  BaseMission.getResetPlaces = Utils.overwrittenFunction(BaseMission.getResetPlaces, WorkshopStorageScreen.getResetPlaces)

  -- Sets the spawn location back to the default locations
  WorkshopScreen.onClose = Utils.appendedFunction(WorkshopScreen.onClose, function (...)
    g_workshopStorageScreen.currentShopLocation = nil
  end)

end

init()