---@class HideMessageDialogEvent
HideMessageDialogEvent = {}
local HideMessageDialogEvent_mt = Class(HideMessageDialogEvent, Event)

InitEventClass(HideMessageDialogEvent, "HideMessageDialogEvent")

function HideMessageDialogEvent.emptyNew()
  vsDebug("HMDE-emptyNew")
	return Event.new(HideMessageDialogEvent_mt)
end

function HideMessageDialogEvent.new(userId)
  vsDebug("HMDE-new")
	local self = HideMessageDialogEvent.emptyNew()
  self.userId = userId

	return self
end

function HideMessageDialogEvent:readStream(streamId, connection)
  vsDebug("HMDE-readStream")
  -- Get data from clients
  self.userId = User.streamReadUserId(streamId)

	self:run(connection)
end

function HideMessageDialogEvent:writeStream(streamId, connection)
  vsDebug("HMDE-writeStream")
  -- Send data out to clients
  User.streamWriteUserId(streamId, self.userId)

end

function HideMessageDialogEvent:run(connection)
  vsDebug("HMDE-run")
  if g_localPlayer.userId == self.userId then
    MessageDialog.hide()
  end
end

function HideMessageDialogEvent.sendEvent(userId)
  vsDebug("HMDE-sendEvent")
	if g_server ~= nil then
    if g_client:getServerConnection():getIsLocal() and g_dedicatedServer == nil then
      vsDebug("HMDE Local Server Host")
      MessageDialog.hide()
    else
      vsDebug("HMDE Dedicated Server Host")
  		g_server:broadcastEvent(HideMessageDialogEvent.new(userId))
    end
    return
	end
  vsDebug("HMDE Client")
	g_client:getServerConnection():sendEvent(HideMessageDialogEvent.new(userId))
end
